<?php
/**
 * Fired when the plugin is uninstalled.
 *
 * @package    SiteEngineAI_Chat
 */

// If uninstall not called from WordPress, then exit.
if ( ! defined( 'WP_UNINSTALL_PLUGIN' ) ) {
	exit;
}

// Delete options
delete_option( 'se_chat_enabled' );
delete_option( 'se_chat_use_local_styles' );
delete_option( 'se_chat_styles' );
delete_option( 'se_chat_version' );

// Delete transients
delete_transient( 'se_chat_site_registered' );

// Delete user meta using WordPress API
delete_metadata( 'user', 0, 'se_chat_notice_dismissed', '', true );

