<?php
/**
 * Plugin Name: SiteEngineAI Chat
 * Plugin URI: https://wordpress.org/plugins/siteengineai-chat/
 * Description: Automatically connects SiteEngineAI chat-bot to your site with the ability to manage styles from WordPress Dashboard. When local styles are present, does NOT request styles from siteengineai.com.
 * Version: 1.0.1
 * Requires at least: 5.0
 * Requires PHP: 7.2
 * Author: SiteEngineAI
 * Author URI: https://siteengineai.com
 * License: GPL v2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 *
 * @package SiteEngineAI_Chat
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

/**
 * Load configuration class.
 */
require_once plugin_dir_path( __FILE__ ) . 'includes/class-siteengineai-config.php';

/**
 * Currently plugin version.
 */
define( 'SE_CHAT_VERSION', SiteEngineAI_Chat_Config::PLUGIN_VERSION );
define( 'SE_CHAT_PLUGIN_DIR', plugin_dir_path( __FILE__ ) );
define( 'SE_CHAT_PLUGIN_URL', plugin_dir_url( __FILE__ ) );

/**
 * The code that runs during plugin activation.
 */
// phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedFunctionFound
function activate_siteengineai_chat() {
	require_once SE_CHAT_PLUGIN_DIR . 'includes/class-siteengineai-activator.php';
	SiteEngineAI_Chat_Activator::activate();
}
register_activation_hook( __FILE__, 'activate_siteengineai_chat' );

/**
 * The code that runs during plugin deactivation.
 */
// phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedFunctionFound
function deactivate_siteengineai_chat() {
	require_once SE_CHAT_PLUGIN_DIR . 'includes/class-siteengineai-deactivator.php';
	SiteEngineAI_Chat_Deactivator::deactivate();
}
register_deactivation_hook( __FILE__, 'deactivate_siteengineai_chat' );

/**
 * Begins execution of the plugin.
 */
// phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedFunctionFound
function run_siteengineai_chat() {
	require_once SE_CHAT_PLUGIN_DIR . 'includes/class-siteengineai-chat.php';
	$plugin = new SiteEngineAI_Chat();
	$plugin->run();
}
run_siteengineai_chat();

