<?php
/**
 * Plugin configuration file.
 * 
 * This file contains all static values, URLs, constants, and default settings
 * used throughout the plugin. Modify values here to change them across the entire codebase.
 *
 * @package    SiteEngineAI_Chat
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Plugin configuration class.
 * 
 * Contains all static values, URLs, constants, and default settings.
 */
class SiteEngineAI_Chat_Config {

	/**
	 * Plugin information.
	 */
	const PLUGIN_VERSION = '1.0.1';

	/**
	 * URLs.
	 */
	const URL_SITEENGINEAI = 'https://siteengineai.com';
	const URL_WORDPRESS_PLUGIN = 'https://wordpress.org/plugins/siteengineai-chat/';
	const URL_LICENSE = 'https://www.gnu.org/licenses/gpl-2.0.html';
	const API_ENDPOINT_CONFIG = '/api/embed/config';
	
	/**
	 * Chat script URL (can be overridden).
	 * 
	 * Default: {SITEENGINEAI_URL}/embed/chat.js
	 * For local development: http://mycore.localhost/embed/chat.js
	 */
	const CHAT_SCRIPT_URL = 'https://siteengineai.com/embed/chat.js';

	/**
	 * WordPress option names.
	 */
	const OPTION_ENABLED = 'se_chat_enabled';
	const OPTION_USE_LOCAL_STYLES = 'se_chat_use_local_styles';
	const OPTION_STYLES = 'se_chat_styles';
	const OPTION_VERSION = 'se_chat_version';
	
	/**
	 * Cache and meta keys.
	 */
	const CACHE_KEY_SITE_REGISTERED = 'se_chat_site_registered';
	const CACHE_EXPIRATION = 3600; // 1 hour in seconds
	const USER_META_NOTICE_DISMISSED = 'se_chat_notice_dismissed';
	
	/**
	 * AJAX action names.
	 */
	const AJAX_ACTION_NOTICE = 'se_chat_notice_action';
	const AJAX_ACTION_SETTINGS = 'se_chat_settings';
	
	/**
	 * Nonce names.
	 */
	const NONCE_NOTICE = 'se_chat_notice_action';
	const NONCE_SETTINGS = 'se_chat_settings';
	
	/**
	 * Admin page slug.
	 */
	const ADMIN_PAGE_SLUG = 'siteengineai-chat';
	const ADMIN_SCREEN_ID = 'toplevel_page_siteengineai-chat';

	/**
	 * Get SiteEngineAI API base URL.
	 *
	 * @return string API base URL.
	 */
	public static function get_api_base() {
		return self::URL_SITEENGINEAI;
	}

	/**
	 * Get SiteEngineAI API config URL.
	 *
	 * @return string API config URL.
	 */
	public static function get_api_config_url() {
		return self::URL_SITEENGINEAI . self::API_ENDPOINT_CONFIG;
	}

	/**
	 * Get SiteEngineAI registration URL.
	 *
	 * @return string Registration URL.
	 */
	public static function get_registration_url() {
		return self::URL_SITEENGINEAI;
	}

	/**
	 * Get chat script URL.
	 *
	 * @return string Chat script URL.
	 */
	public static function get_chat_script_url() {
		return self::CHAT_SCRIPT_URL;
	}

	/**
	 * Get default styles array.
	 *
	 * @return array Default styles.
	 */
	public static function get_default_styles() {
		return array(
			'buttonIcon'            => '🗨️',
			'buttonTitle'           => 'Ask AI',
			'headerTitle'           => 'AI Assistant',
			'newChatText'           => 'New chat',
			'placeholder'           => 'Type your question...',
			'welcomeMessage'        => 'Hello! How can I help you today?',
			'thinkingText'          => 'Thinking...',
			'buttonColor'           => 'linear-gradient(135deg,#667eea 0%,#764ba2 100%)',
			'buttonHoverColor'      => '#2a2a2a',
			'buttonPosition'        => 'right:20px;bottom:20px',
			'windowWidth'           => '360px',
			'windowHeight'          => '520px',
			'userMessageColor'      => '#1a1a1a',
			'aiMessageColor'        => '#ffffff',
			'windowBackgroundColor' => '#ffffff',
			'bodyBackgroundColor'   => '#fafafa',
			'fontFamily'            => '',
			'fontSize'              => '14px',
			'windowBorderRadius'    => '20px',
			'messageBorderRadius'   => '16px',
			'buttonSize'            => '56px',
			'linkColor'             => '#0066cc',
			'sendButtonColor'       => '#1a1a1a',
			'sendButtonIcon'        => '',
			'sendButtonText'        => 'Send',
		);
	}

	/**
	 * Get allowed style keys (camelCase format).
	 *
	 * @return array Allowed style keys.
	 */
	public static function get_allowed_style_keys() {
		return array(
			'buttonIcon',
			'buttonTitle',
			'headerTitle',
			'newChatText',
			'placeholder',
			'welcomeMessage',
			'thinkingText',
			'buttonColor',
			'buttonHoverColor',
			'buttonPosition',
			'windowWidth',
			'windowHeight',
			'userMessageColor',
			'aiMessageColor',
			'windowBackgroundColor',
			'bodyBackgroundColor',
			'fontFamily',
			'fontSize',
			'windowBorderRadius',
			'messageBorderRadius',
			'buttonSize',
			'linkColor',
			'sendButtonColor',
			'sendButtonIcon',
			'sendButtonText',
		);
	}

	/**
	 * Get key mapping for converting lowercase keys to camelCase.
	 *
	 * @return array Key mapping array (lowercase => camelCase).
	 */
	public static function get_key_mapping() {
		return array(
			'buttonicon'            => 'buttonIcon',
			'buttontitle'           => 'buttonTitle',
			'headertitle'           => 'headerTitle',
			'newchattext'           => 'newChatText',
			'welcomemessage'        => 'welcomeMessage',
			'thinkingtext'          => 'thinkingText',
			'buttoncolor'           => 'buttonColor',
			'buttonhovercolor'      => 'buttonHoverColor',
			'buttonposition'        => 'buttonPosition',
			'windowwidth'           => 'windowWidth',
			'windowheight'          => 'windowHeight',
			'usermessagecolor'      => 'userMessageColor',
			'aimessagecolor'        => 'aiMessageColor',
			'windowbackgroundcolor' => 'windowBackgroundColor',
			'bodybackgroundcolor'   => 'bodyBackgroundColor',
			'fontfamily'            => 'fontFamily',
			'fontsize'              => 'fontSize',
			'windowborderradius'    => 'windowBorderRadius',
			'messageborderradius'   => 'messageBorderRadius',
			'buttonsize'            => 'buttonSize',
			'linkcolor'             => 'linkColor',
			'sendbuttoncolor'       => 'sendButtonColor',
			'sendbuttonicon'        => 'sendButtonIcon',
			'sendbuttontext'        => 'sendButtonText',
		);
	}

	/**
	 * Get default option values.
	 *
	 * @return array Default option values.
	 */
	public static function get_default_options() {
		return array(
			self::OPTION_ENABLED          => true,
			self::OPTION_USE_LOCAL_STYLES => true,
			self::OPTION_STYLES           => self::get_default_styles(),
		);
	}
}

