<?php
/**
 * Fired during plugin activation.
 *
 * @package    SiteEngineAI_Chat
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Fired during plugin activation.
 */
class SiteEngineAI_Chat_Activator {

	/**
	 * Activate the plugin.
	 */
	public static function activate() {
		// Get default options from config
		$default_options = SiteEngineAI_Chat_Config::get_default_options();

		if ( false === get_option( SiteEngineAI_Chat_Config::OPTION_ENABLED ) ) {
			add_option( SiteEngineAI_Chat_Config::OPTION_ENABLED, $default_options[ SiteEngineAI_Chat_Config::OPTION_ENABLED ] );
		}

		if ( false === get_option( SiteEngineAI_Chat_Config::OPTION_USE_LOCAL_STYLES ) ) {
			add_option( SiteEngineAI_Chat_Config::OPTION_USE_LOCAL_STYLES, $default_options[ SiteEngineAI_Chat_Config::OPTION_USE_LOCAL_STYLES ] );
		}

		if ( false === get_option( SiteEngineAI_Chat_Config::OPTION_STYLES ) ) {
			add_option( SiteEngineAI_Chat_Config::OPTION_STYLES, $default_options[ SiteEngineAI_Chat_Config::OPTION_STYLES ] );
		}

		// Set version
		update_option( SiteEngineAI_Chat_Config::OPTION_VERSION, SiteEngineAI_Chat_Config::PLUGIN_VERSION );
	}
}

