<?php
/**
 * Admin settings page.
 *
 * @package    SiteEngineAI_Chat
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Variables are passed from display_plugin_setup_page() method
// Ensure all variables are defined (prefixed to avoid global namespace conflicts)
if ( ! isset( $se_chat_settings_saved ) ) {
	$se_chat_settings_saved = isset( $settings_saved ) ? $settings_saved : false;
}
if ( ! isset( $se_chat_check_result ) ) {
	$se_chat_check_result = isset( $check_result ) ? $check_result : $site_checker->check_site_registration();
}
?>

<div class="wrap se-chat-settings-wrap">
	<div class="se-chat-header">
		<h1><?php echo esc_html( get_admin_page_title() ); ?></h1>
		<p><?php esc_html_e( 'Customize your SiteEngineAI Chat widget appearance and behavior', 'siteengineai-chat' ); ?></p>
		
		<?php
		// Show site registration status in header
		$se_chat_site_url = $site_checker->get_site_url();
		if ( ! $se_chat_check_result['registered'] ) {
			?>
			<div class="se-chat-header-notice notice notice-error">
				<p>
					<strong><?php esc_html_e( '⚠️ Site Not Registered', 'siteengineai-chat' ); ?></strong>
					<?php
					printf(
						/* translators: 1: Site URL */
						esc_html__( 'Your site %1$s is not registered in SiteEngineAI. The chat will not work until you register your site.', 'siteengineai-chat' ),
						'<code>' . esc_html( $se_chat_site_url ) . '</code>'
					);
					?>
				</p>
				<p>
					<a href="<?php echo esc_url( SiteEngineAI_Chat_Config::get_registration_url() ); ?>" target="_blank" rel="noopener noreferrer" class="button button-primary">
						<?php esc_html_e( 'Register Site on SiteEngineAI', 'siteengineai-chat' ); ?>
					</a>
				</p>
			</div>
			<?php
		} else {
			?>
			<div class="se-chat-header-notice notice notice-success">
				<p>
					<strong><?php esc_html_e( '✅ Site Registered', 'siteengineai-chat' ); ?></strong>
					<?php
					printf(
						/* translators: 1: Site URL */
						esc_html__( 'Your site %1$s is registered in SiteEngineAI and ready to use.', 'siteengineai-chat' ),
						'<code>' . esc_html( $se_chat_site_url ) . '</code>'
					);
					?>
				</p>
			</div>
			<?php
		}
		?>
		
		<div class="se-chat-header-actions">
			<button type="button" class="button se-chat-check-registration" id="se-chat-check-registration">
				<?php esc_html_e( 'Check Again', 'siteengineai-chat' ); ?>
			</button>
		</div>
	</div>

	<?php if ( $se_chat_settings_saved ) : ?>
		<div class="notice notice-success is-dismissible">
			<p><strong><?php esc_html_e( 'Settings saved successfully!', 'siteengineai-chat' ); ?></strong></p>
		</div>
	<?php endif; ?>

	<form method="post" action="">
		<?php wp_nonce_field( SiteEngineAI_Chat_Config::NONCE_SETTINGS, 'se_chat_nonce' ); ?>

		<!-- General Settings Card -->
		<div class="se-chat-card">
			<h2><?php esc_html_e( 'General Settings', 'siteengineai-chat' ); ?></h2>

			<table class="form-table">
				<tr>
					<th scope="row"><?php esc_html_e( 'Enable Chat', 'siteengineai-chat' ); ?></th>
					<td>
						<div style="display: flex; align-items: center;">
							<label class="se-chat-toggle">
								<input type="hidden" name="se_chat_enabled" value="0">
								<input type="checkbox" name="se_chat_enabled" id="se_chat_enabled" value="1" <?php checked( $enabled, true ); ?>>
								<span class="se-chat-toggle-slider"></span>
							</label>
							<label for="se_chat_enabled" style="margin: 0; cursor: pointer;">
								<?php esc_html_e( 'Enable SiteEngineAI Chat on your website', 'siteengineai-chat' ); ?>
							</label>
						</div>
					</td>
				</tr>

				<tr>
					<th scope="row"><?php esc_html_e( 'Use Local Styles', 'siteengineai-chat' ); ?></th>
					<td>
						<div style="display: flex; align-items: center;">
							<label class="se-chat-toggle">
								<input type="hidden" name="se_chat_use_local_styles" value="0">
								<input type="checkbox" name="se_chat_use_local_styles" id="se_chat_use_local_styles" value="1" <?php checked( $use_local_styles, true ); ?>>
								<span class="se-chat-toggle-slider"></span>
							</label>
							<label for="se_chat_use_local_styles" style="margin: 0; cursor: pointer;">
								<?php esc_html_e( 'Use styles from WordPress instead of loading from siteengineai.com', 'siteengineai-chat' ); ?>
							</label>
						</div>
						<p class="description">
							<?php esc_html_e( 'If enabled, the chat will use styles configured here and will NOT request styles from siteengineai.com. If disabled, styles will be loaded from SiteEngineAI server.', 'siteengineai-chat' ); ?>
						</p>
					</td>
				</tr>
			</table>
		</div>

		<!-- Text & Content Settings Card -->
		<div class="se-chat-card">
			<h2><?php esc_html_e( 'Text & Content', 'siteengineai-chat' ); ?></h2>

			<table class="form-table">
				<tr>
					<th scope="row"><label for="buttonIcon"><?php esc_html_e( 'Button Icon', 'siteengineai-chat' ); ?></label></th>
					<td>
						<input type="text" name="se_chat_styles[buttonIcon]" id="buttonIcon" 
							   value="<?php echo esc_attr( $styles['buttonIcon'] ?? '🗨️' ); ?>" class="regular-text">
						<span class="se-chat-icon-preview"><?php echo esc_html( $styles['buttonIcon'] ?? '🗨️' ); ?></span>
						<p class="description"><?php esc_html_e( 'Emoji or icon for the chat button', 'siteengineai-chat' ); ?></p>
					</td>
				</tr>

				<tr>
					<th scope="row"><label for="buttonTitle"><?php esc_html_e( 'Button Title', 'siteengineai-chat' ); ?></label></th>
					<td>
						<input type="text" name="se_chat_styles[buttonTitle]" id="buttonTitle" 
							   value="<?php echo esc_attr( $styles['buttonTitle'] ?? 'Ask AI' ); ?>" class="regular-text">
						<p class="description"><?php esc_html_e( 'Tooltip text shown when hovering over the chat button', 'siteengineai-chat' ); ?></p>
					</td>
				</tr>

				<tr>
					<th scope="row"><label for="headerTitle"><?php esc_html_e( 'Header Title', 'siteengineai-chat' ); ?></label></th>
					<td>
						<input type="text" name="se_chat_styles[headerTitle]" id="headerTitle" 
							   value="<?php echo esc_attr( $styles['headerTitle'] ?? $styles['headertitle'] ?? 'AI Assistant' ); ?>" class="regular-text">
					</td>
				</tr>

				<tr>
					<th scope="row"><label for="newChatText"><?php esc_html_e( 'New Chat Text', 'siteengineai-chat' ); ?></label></th>
					<td>
						<input type="text" name="se_chat_styles[newChatText]" id="newChatText" 
							   value="<?php echo esc_attr( $styles['newChatText'] ?? 'New chat' ); ?>" class="regular-text">
					</td>
				</tr>

				<tr>
					<th scope="row"><label for="placeholder"><?php esc_html_e( 'Placeholder Text', 'siteengineai-chat' ); ?></label></th>
					<td>
						<input type="text" name="se_chat_styles[placeholder]" id="placeholder" 
							   value="<?php echo esc_attr( $styles['placeholder'] ?? 'Type your question...' ); ?>" class="regular-text">
					</td>
				</tr>

				<tr>
					<th scope="row"><label for="welcomeMessage"><?php esc_html_e( 'Welcome Message', 'siteengineai-chat' ); ?></label></th>
					<td>
						<input type="text" name="se_chat_styles[welcomeMessage]" id="welcomeMessage" 
							   value="<?php echo esc_attr( $styles['welcomeMessage'] ?? 'Hello! How can I help you today?' ); ?>" class="regular-text">
					</td>
				</tr>

				<tr>
					<th scope="row"><label for="thinkingText"><?php esc_html_e( 'Thinking Text', 'siteengineai-chat' ); ?></label></th>
					<td>
						<input type="text" name="se_chat_styles[thinkingText]" id="thinkingText" 
							   value="<?php echo esc_attr( $styles['thinkingText'] ?? 'Thinking...' ); ?>" class="regular-text">
					</td>
				</tr>

				<tr>
					<th scope="row"><label for="sendButtonText"><?php esc_html_e( 'Send Button Text', 'siteengineai-chat' ); ?></label></th>
					<td>
						<input type="text" name="se_chat_styles[sendButtonText]" id="sendButtonText" 
							   value="<?php echo esc_attr( $styles['sendButtonText'] ?? 'Send' ); ?>" class="regular-text">
					</td>
				</tr>

				<tr>
					<th scope="row"><label for="sendButtonIcon"><?php esc_html_e( 'Send Button Icon', 'siteengineai-chat' ); ?></label></th>
					<td>
						<input type="text" name="se_chat_styles[sendButtonIcon]" id="sendButtonIcon" 
							   value="<?php echo esc_attr( $styles['sendButtonIcon'] ?? '' ); ?>" class="regular-text">
						<p class="description"><?php esc_html_e( 'Optional emoji or icon for the send button', 'siteengineai-chat' ); ?></p>
					</td>
				</tr>
			</table>
		</div>

		<!-- Button & Position Settings Card -->
		<div class="se-chat-card">
			<h2><?php esc_html_e( 'Button & Position', 'siteengineai-chat' ); ?></h2>

			<div class="se-chat-row">
				<div>
					<table class="form-table">
						<tr>
							<th scope="row"><label for="buttonColor"><?php esc_html_e( 'Button Color', 'siteengineai-chat' ); ?></label></th>
							<td>
								<input type="text" name="se_chat_styles[buttonColor]" id="buttonColor" 
									   value="<?php echo esc_attr( $styles['buttonColor'] ?? 'linear-gradient(135deg,#667eea 0%,#764ba2 100%)' ); ?>" 
									   class="regular-text se-color-picker">
								<p class="description"><?php esc_html_e( 'CSS color value (e.g., #1a1a1a or linear-gradient(...))', 'siteengineai-chat' ); ?></p>
							</td>
						</tr>

						<tr>
							<th scope="row"><label for="buttonHoverColor"><?php esc_html_e( 'Button Hover Color', 'siteengineai-chat' ); ?></label></th>
							<td>
								<input type="text" name="se_chat_styles[buttonHoverColor]" id="buttonHoverColor" 
									   value="<?php echo esc_attr( $styles['buttonHoverColor'] ?? '#2a2a2a' ); ?>" 
									   class="regular-text se-color-picker">
							</td>
						</tr>

						<tr>
							<th scope="row"><label for="buttonSize"><?php esc_html_e( 'Button Size', 'siteengineai-chat' ); ?></label></th>
							<td>
								<input type="text" name="se_chat_styles[buttonSize]" id="buttonSize" 
									   value="<?php echo esc_attr( $styles['buttonSize'] ?? '56px' ); ?>" class="regular-text">
								<p class="description"><?php esc_html_e( 'e.g., 56px, 60px', 'siteengineai-chat' ); ?></p>
							</td>
						</tr>

						<tr>
							<th scope="row"><label for="buttonPosition"><?php esc_html_e( 'Button Position', 'siteengineai-chat' ); ?></label></th>
							<td>
								<input type="text" name="se_chat_styles[buttonPosition]" id="buttonPosition" 
									   value="<?php echo esc_attr( $styles['buttonPosition'] ?? 'right:20px;bottom:20px' ); ?>" class="regular-text">
								<p class="description"><?php esc_html_e( 'CSS position values (e.g., right:20px;bottom:20px)', 'siteengineai-chat' ); ?></p>
							</td>
						</tr>
					</table>
				</div>
			</div>
		</div>

		<!-- Window Settings Card -->
		<div class="se-chat-card">
			<h2><?php esc_html_e( 'Window Settings', 'siteengineai-chat' ); ?></h2>

			<div class="se-chat-row">
				<div>
					<table class="form-table">
						<tr>
							<th scope="row"><label for="windowWidth"><?php esc_html_e( 'Window Width', 'siteengineai-chat' ); ?></label></th>
							<td>
								<input type="text" name="se_chat_styles[windowWidth]" id="windowWidth" 
									   value="<?php echo esc_attr( $styles['windowWidth'] ?? '360px' ); ?>" class="regular-text">
								<p class="description"><?php esc_html_e( 'e.g., 360px, 400px', 'siteengineai-chat' ); ?></p>
							</td>
						</tr>

						<tr>
							<th scope="row"><label for="windowHeight"><?php esc_html_e( 'Window Height', 'siteengineai-chat' ); ?></label></th>
							<td>
								<input type="text" name="se_chat_styles[windowHeight]" id="windowHeight" 
									   value="<?php echo esc_attr( $styles['windowHeight'] ?? '520px' ); ?>" class="regular-text">
								<p class="description"><?php esc_html_e( 'e.g., 520px, 600px', 'siteengineai-chat' ); ?></p>
							</td>
						</tr>

						<tr>
							<th scope="row"><label for="windowBorderRadius"><?php esc_html_e( 'Window Border Radius', 'siteengineai-chat' ); ?></label></th>
							<td>
								<input type="text" name="se_chat_styles[windowBorderRadius]" id="windowBorderRadius" 
									   value="<?php echo esc_attr( $styles['windowBorderRadius'] ?? '20px' ); ?>" class="regular-text">
								<p class="description"><?php esc_html_e( 'e.g., 20px, 12px', 'siteengineai-chat' ); ?></p>
							</td>
						</tr>
					</table>
				</div>
			</div>
		</div>

		<!-- Colors Card -->
		<div class="se-chat-card">
			<h2><?php esc_html_e( 'Colors', 'siteengineai-chat' ); ?></h2>

			<div class="se-chat-row">
				<div>
					<h3><?php esc_html_e( 'Window Colors', 'siteengineai-chat' ); ?></h3>
					<table class="form-table">
						<tr>
							<th scope="row"><label for="windowBackgroundColor"><?php esc_html_e( 'Window Background', 'siteengineai-chat' ); ?></label></th>
							<td>
								<input type="text" name="se_chat_styles[windowBackgroundColor]" id="windowBackgroundColor" 
									   value="<?php echo esc_attr( $styles['windowBackgroundColor'] ?? '#ffffff' ); ?>" 
									   class="regular-text se-color-picker">
							</td>
						</tr>

						<tr>
							<th scope="row"><label for="bodyBackgroundColor"><?php esc_html_e( 'Body Background', 'siteengineai-chat' ); ?></label></th>
							<td>
								<input type="text" name="se_chat_styles[bodyBackgroundColor]" id="bodyBackgroundColor" 
									   value="<?php echo esc_attr( $styles['bodyBackgroundColor'] ?? '#fafafa' ); ?>" 
									   class="regular-text se-color-picker">
							</td>
						</tr>
					</table>
				</div>

				<div>
					<h3><?php esc_html_e( 'Message Colors', 'siteengineai-chat' ); ?></h3>
					<table class="form-table">
						<tr>
							<th scope="row"><label for="userMessageColor"><?php esc_html_e( 'User Message Color', 'siteengineai-chat' ); ?></label></th>
							<td>
								<input type="text" name="se_chat_styles[userMessageColor]" id="userMessageColor" 
									   value="<?php echo esc_attr( $styles['userMessageColor'] ?? '#1a1a1a' ); ?>" 
									   class="regular-text se-color-picker">
							</td>
						</tr>

						<tr>
							<th scope="row"><label for="aiMessageColor"><?php esc_html_e( 'AI Message Color', 'siteengineai-chat' ); ?></label></th>
							<td>
								<input type="text" name="se_chat_styles[aiMessageColor]" id="aiMessageColor" 
									   value="<?php echo esc_attr( $styles['aiMessageColor'] ?? '#ffffff' ); ?>" 
									   class="regular-text se-color-picker">
							</td>
						</tr>

						<tr>
							<th scope="row"><label for="linkColor"><?php esc_html_e( 'Link Color', 'siteengineai-chat' ); ?></label></th>
							<td>
								<input type="text" name="se_chat_styles[linkColor]" id="linkColor" 
									   value="<?php echo esc_attr( $styles['linkColor'] ?? '#0066cc' ); ?>" 
									   class="regular-text se-color-picker">
							</td>
						</tr>

						<tr>
							<th scope="row"><label for="sendButtonColor"><?php esc_html_e( 'Send Button Color', 'siteengineai-chat' ); ?></label></th>
							<td>
								<input type="text" name="se_chat_styles[sendButtonColor]" id="sendButtonColor" 
									   value="<?php echo esc_attr( $styles['sendButtonColor'] ?? '#1a1a1a' ); ?>" 
									   class="regular-text se-color-picker">
							</td>
						</tr>
					</table>
				</div>
			</div>
		</div>

		<!-- Typography Card -->
		<div class="se-chat-card">
			<h2><?php esc_html_e( 'Typography', 'siteengineai-chat' ); ?></h2>

			<table class="form-table">
				<tr>
					<th scope="row"><label for="fontFamily"><?php esc_html_e( 'Font Family', 'siteengineai-chat' ); ?></label></th>
					<td>
						<input type="text" name="se_chat_styles[fontFamily]" id="fontFamily" 
							   value="<?php echo esc_attr( $styles['fontFamily'] ?? '' ); ?>" class="regular-text">
						<p class="description"><?php esc_html_e( 'CSS font-family value (e.g., Arial, sans-serif or "Open Sans", sans-serif)', 'siteengineai-chat' ); ?></p>
					</td>
				</tr>

				<tr>
					<th scope="row"><label for="fontSize"><?php esc_html_e( 'Font Size', 'siteengineai-chat' ); ?></label></th>
					<td>
						<input type="text" name="se_chat_styles[fontSize]" id="fontSize" 
							   value="<?php echo esc_attr( $styles['fontSize'] ?? '14px' ); ?>" class="regular-text">
						<p class="description"><?php esc_html_e( 'e.g., 14px, 16px', 'siteengineai-chat' ); ?></p>
					</td>
				</tr>

				<tr>
					<th scope="row"><label for="messageBorderRadius"><?php esc_html_e( 'Message Border Radius', 'siteengineai-chat' ); ?></label></th>
					<td>
						<input type="text" name="se_chat_styles[messageBorderRadius]" id="messageBorderRadius" 
							   value="<?php echo esc_attr( $styles['messageBorderRadius'] ?? '16px' ); ?>" class="regular-text">
						<p class="description"><?php esc_html_e( 'e.g., 16px, 12px', 'siteengineai-chat' ); ?></p>
					</td>
				</tr>
			</table>
		</div>

		<!-- Save Button -->
		<div class="se-chat-save-container">
			<?php submit_button( __( 'Save Settings', 'siteengineai-chat' ), 'primary', 'se_chat_save', false ); ?>
		</div>
	</form>
</div>
