jQuery(document).ready(function($) {
	// Initialize color pickers
	$('.se-color-picker').wpColorPicker();

	// Update icon preview when icon input changes
	$('#buttonIcon').on('input', function() {
		$('.se-chat-icon-preview').text($(this).val() || '🗨️');
	});

	// Handle check registration button in header
	$('#se-chat-check-registration').on('click', function(e) {
		e.preventDefault();
		
		var $button = $(this);
		var originalText = $button.text();
		
		// Disable button
		$button.prop('disabled', true).text('Checking...');
		
		$.ajax({
			url: seChatAdmin.ajaxurl,
			type: 'POST',
			data: {
				action: seChatAdmin.ajax_action,
				action_type: 'check',
				nonce: seChatAdmin.nonce
			},
			success: function(response) {
				if (response.success) {
					// Reload page to show updated status
					window.location.reload();
				} else {
					alert('Error: ' + response.data.message);
					$button.prop('disabled', false).text(originalText);
				}
			},
			error: function() {
				alert('Network error. Please try again.');
				$button.prop('disabled', false).text(originalText);
			}
		});
	});

	// Handle notice actions
	$('.se-chat-dismiss-notice, .se-chat-check-again').on('click', function(e) {
		e.preventDefault();
		
		var $button = $(this);
		var action = $button.data('action');
		var $notice = $button.closest('.se-chat-site-notice');
		
		// Disable button
		$button.prop('disabled', true).text('Processing...');
		
		$.ajax({
			url: seChatAdmin.ajaxurl,
			type: 'POST',
			data: {
				action: seChatAdmin.ajax_action,
				action_type: action,
				nonce: seChatAdmin.nonce
			},
			success: function(response) {
				if (response.success) {
					if (action === 'dismiss') {
						$notice.fadeOut(300, function() {
							$(this).remove();
						});
					} else if (action === 'check') {
						if (response.data.registered) {
							$notice.removeClass('notice-warning').addClass('notice-success');
							$notice.find('p:first').html(
								'<strong>SiteEngineAI Chat:</strong> ' +
								'Your site is registered and ready to use!'
							);
							$notice.find('p:last').remove();
						} else {
							alert('Site is still not registered: ' + response.data.message);
						}
					}
				} else {
					alert('Error: ' + response.data.message);
				}
			},
			error: function() {
				alert('Network error. Please try again.');
			},
			complete: function() {
				$button.prop('disabled', false);
				if (action === 'check') {
					$button.text('Check Again');
				}
			}
		});
	});
});

